package prix;

import static org.junit.Assert.assertEquals;

import org.junit.Before;
import org.junit.Test;

public class PrixCalculatorTest {

	private PrixCalculator prixCalculator;

	@Before
	public void setup() {
		prixCalculator = new PrixCalculator();
	}

	@Test
	public void doit_appliquer_un_prix_sans_remise() {

		double price = prixCalculator.calculatePrice(3, 1.25);

		assertEquals(3.75, price, 0.01);
	}

	@Test
	public void doit_appliquer_une_remise_de_3_pourcents_si_plus_de_1000() {

		double price = prixCalculator.calculatePrice(100, 12.10);

		assertEquals(1173.70, price, 0.01);
	}

	@Test
	public void doit_appliquer_une_remise_de_5_pourcents_si_plus_de_5000() {

		double price = prixCalculator.calculatePrice(500, 12.10);

		assertEquals(5747.50, price, 0.01);

	}

	@Test
	public void doit_appliquer_une_remise_de_7_pourcents_si_plus_de_7000() {

		double price = prixCalculator.calculatePrice(700, 12.10);

		assertEquals(7877.10, price, 0.01);

	}

}
