package tennis;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import org.junit.Test;

public class ControlerTest {

	@Test
	public void test_button_player_1_pressed() {
		Game mockGame = mock(Game.class);
		Gui mockGui = mock(Gui.class);
		ScoreBuilder mockScoreBuilder = mock(ScoreBuilder.class);
		when(mockScoreBuilder.computeScore(mockGame)).thenReturn("15-5");
		Controler controler = new Controler(mockGame, mockGui, mockScoreBuilder);

		controler.buttonPlayer1Pressed();

		verify(mockGame).player1Scored();
		verify(mockGui).displayScore("15-0");
	}

}
